<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateMovementsNotificationsTypes extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => false,
                'event'     => "Inside\Movements\Events\CongratulateUserEvent",
                'model'     => null,
                'type'      => 'system',
                'action'    => 'nomination',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.movements.congratulate.nomination.title',
                    'description' => 'notifications.movements.congratulate.nomination.description',
                    'text'        => 'notifications.movements.congratulate.nomination.text',
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => false,
                'event'     => "Inside\Movements\Events\CongratulateUserEvent",
                'model'     => null,
                'type'      => 'system',
                'action'    => 'arrival',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.movements.congratulate.arrival.title',
                    'description' => 'notifications.movements.congratulate.arrival.description',
                    'text'        => 'notifications.movements.congratulate.arrival.text',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
