<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'movements',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Mouvements',
            'en' => 'Movements',
            'es' => 'Movimientos',
            'de' => 'Bewegungen',
            'pt' => 'Movimentos',
            'nl' => 'Bewegingen',
        ],
    ],
    'fields' => [
        [
            'name' => 'movements_users',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Utilisateur',
                'en' => 'User',
                'es' => 'Usuario',
                'de' => 'Benutzer',
                'pt' => 'Usuário',
                'nl' => 'Gebruiker',
            ],
            'widget' => [
                'settings' => [],
                'weight' => 0,
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'movements_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Catégorie',
                'en' => 'Category',
                'es' => 'Categoría',
                'de' => 'Kategorie',
                'pt' => 'Categoria',
                'nl' => 'Categorie',
            ],
            'widget' => [
                'settings' => [],
                'weight' => 1,
                'type' => BridgeContentType::SELECT_WIDGET,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['movements_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'movements_description',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Description',
                'en' => 'Description',
                'es' => 'Descripción',
                'de' => 'Beschreibung',
                'pt' => 'Descrição',
                'nl' => 'Beschrijving',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
