<?php

use Illuminate\Support\Facades\Broadcast;
use Inside\Authentication\Models\User;
use Inside\Groups\Models\Group;

Broadcast::channel('inside_groups.group.{groupUuid}', function ($user, $groupUuid) {
    $group = Group::where('original_uuid', $groupUuid)->firstOrFail();
    if ($user->hasRole('super_administrator') || $group->type == 'public' || $group->members->contains($user)) {
        return ['id' => $group->id, 'uuid' => $group->original_uuid, 'name' => $group->name];
    }
});

Broadcast::channel(
    'inside_groups.admin.{groupUuid}',
    function ($user, $groupUuid) {
        $group = Group::where('original_uuid', $groupUuid)->firstOrFail();
        return $user->hasRole('super_administrator') || $group->admins->contains($user);
    }
);

Broadcast::channel(
    'inside_groups.{groupUuid}',
    function ($user, $groupUuid) {
        $group = Group::where('original_uuid', $groupUuid)->firstOrFail();
        return $user->hasRole('super_administrator') || $group->type == 'public' || $group->members->contains($user);
    }
);
