<?php

namespace Inside\Groups\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;
use Inside\Authentication\Models\User;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property integer $id
 * @property integer $group_id
 * @property string $user_uuid
 * @property Carbon $last_activity_at
 * @property-read Group $group
 * @property-read User $user
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity newQuery()
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity query()
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity whereGroupId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity whereLastActivityAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\Inside\Groups\Models\GroupActivity whereUserUuid($value)
 * @OA\Schema (schema="Inside\Groups\Models\GroupActivity",title="group_activity",type="object",description="Dynamic model generated by inside content",@OA\Property(property="id",
 * title="id",
 * type="integer",
 * description=""),
 * @OA\Property (property="group_id",
 * title="group_id",
 * type="integer",
 * description=""),
 * @OA\Property (property="user_uuid",
 * title="user_uuid",
 * type="string",
 * description=""),
 * @OA\Property (property="last_activity_at",
 * title="last_activity_at",
 * type="\Illuminate\Support\Carbon",
 * description=""),
 * @OA\Property (property="group",
 * title="group",
 * type="\Inside\Groups\Models\Group",
 * description=""),
 * @OA\Property (property="user",
 * title="user",
 * type="\Inside\Authentication\Models\User",
 * description=""))
 */
class GroupActivity extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @var string
     */
    protected $table = 'group_activities';

    /**
     * @var array
     */
    protected $guarded = [];

    /**
     * @var array
     */
    protected $with = [];

    /**
     * @var array
     */
    protected $casts = [];

    /**
     * @var array
     */
    protected $dates = [
        'last_activity_at',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function group(): BelongsTo
    {
        return $this->belongsTo(Group::class);
    }
}
