<?php

namespace Inside\Groups\Listeners;

use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Events\UserJoinedAGroupEvent;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class UserJoinAGroupListener extends BaseNotificationListener
{
    /**
     * @param UserJoinedAGroupEvent $event
     * @return void
     */
    public function handle(UserJoinedAGroupEvent $event): void
    {
        $group = $event->group;
        $user = $event->user;
        $from = $event->from;

        if (GroupsHelper::isGroupAdmin($group, $user)) {
            // Subscribe to report
        }

        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('model', Groups::class)
            ->where('type', 'group')
            ->where('action', 'custom')
            ->where('event', UserJoinedAGroupEvent::class)
            ->get();

        foreach ($types as $type) {
            $this->when = $this->getInterval($type, $group);
            $this->route = $user;
            if (!$this->checkUniqueness($type, $group, $user) || !$user->status) {
                continue;
            }
            $this->notify($type, $user, $group, ['from' => $from->uuid]);
        }
    }
}
