<?php

namespace Inside\Groups\Listeners;

use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Events\UserAskedToJoinAGroupEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class UserAskedToJoinAGroupListener extends BaseNotificationListener
{
    /**
     * @param UserAskedToJoinAGroupEvent $event
     * @return void
     */
    public function handle(UserAskedToJoinAGroupEvent $event): void
    {
        $group = $event->group;
        $from = $event->from;
        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('model', Groups::class)
            ->where('type', 'group')
            ->where('action', 'custom')
            ->where('event', UserAskedToJoinAGroupEvent::class)
            ->get();

        foreach ($types as $type) {
            if ($type->role && $type->via === 'web') {
                if ($type->roles->first()) {
                    $this->route = $type->roles->first();
                    $this->notify($type, null, $event->group, ['from' => $event->group->author]);
                }
                continue;
            }

            foreach ($group->members as $admin) {
                /** @var ?User $subscriber */
                $subscriber = User::find($admin->uuid);
                $this->when = $this->getInterval($type, $group);
                $this->route = $subscriber;
                if (! $this->checkUniqueness($type, $group, $subscriber)) {
                    continue;
                }
                $this->notify($type, $subscriber, $group, ['from' => $from->uuid]);
            }
        }
    }
}
