<?php

declare(strict_types=1);

namespace Inside\Groups\Listeners;

use Inside\Content\Events\ContentProcessedEvent;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Groups\Models\Group;

final class GroupsActivityListener
{
    public function handle(ContentProcessedEvent $event): void
    {
        $model = $event->model;

        if (! GroupsHelper::isGroupContentType($model->content_type)) {
            return;
        }

        $model->groups?->pluck('uuid')?->each(function (string $uuid) use ($model) {
            Group::whereOriginalUuid($uuid)->first()?->update(['last_activity' => $model->updated_at]);
        });
    }
}
