<?php

namespace Inside\Groups\Listeners;

use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Groups\Events\UserGrantedAdminEvent;
use Inside\Notify\Events\CustomNotificationEvent;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class GrantUserAdminListener
{
    /**
     * @param UserGrantedAdminEvent $event
     * @return void
     */
    public function handle(UserGrantedAdminEvent $event)
    {
        /** @var ?NotificationType $notificationType */
        $notificationType = NotificationType::where(
            [
                'via' => 'web',
                'default' => false,
                'event' => CustomNotificationEvent::class,
                'model' => GroupsPosts::class,
                'action' => 'report',
                'type' => 'global',
                'condition' => 'groups:' . $event->group->uuid,
                'multiple' => true,
                'language' => true,
                'profile' => false,
            ]
        )->first();
        if ($notificationType) {
            NotificationSubscriber::firstOrCreate(
                [
                    'user_uuid' => $event->userUuid,
                    'notification_type_id' => $notificationType->id,
                ]
            );
        }
    }
}
