<?php

namespace Inside\Groups\Jobs;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Groups\Events\UserJoinedAGroupEvent;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Groups\Models\Group;
use Inside\Jobs\Job;
use Inside\Notify\Models\NotificationType;

class AddNewGroupMembers extends Job
{
    public function __construct(
        private Collection $users,
        private Group $group,
        private User $from
    ) {
    }

    public function handle(): void
    {
        $this->users->each(function (User $user) {
            GroupsHelper::addUserToGroupMembers($user->uuid, $this->group->original);
            UserJoinedAGroupEvent::dispatch($this->group->original, $user, $this->from);
        });

        NotificationType::where('condition', "groups:" . $this->group->original_uuid)->where('action', 'custom')
            ->each(fn (NotificationType $type) => $type->subscribers()->syncWithoutDetaching($this->users->pluck('uuid')));
    }
}
