<?php

namespace Inside\Groups\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Inside\Content\Models\Contents\Groups;

/**
 * @package Inside\Groups\Http\Middlewares
 */
class HidePendingMembersFieldWhenNeeded
{
    public function handle(Request $request, Closure $next): mixed
    {
        $response = $next($request);
        if ($response instanceof Response && $response->getStatusCode() != 200) {
            return $response;
        }

        $pattern = '#^api/v1/form/groups/[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12}$#';
        if (
            $request->getMethod() == 'GET'
            && ($request->path() == 'api/v1/form/groups' || preg_match($pattern, $request->path()))
        ) {
            $response = $this->patch($request, $response);
        }

        return $response;
    }

    protected function patch(Request $request, Response $response): Response
    {
        if ($request->path() == 'api/v1/form/groups') {
            return $this->removePendingMembersField($response);
        } else {
            $matches = null;
            preg_match('#^api/v1/form/groups/(.*)?$#', $request->path(), $matches);
            if (count($matches) !== 2) {
                return $response;
            }

            $group = Groups::find($matches[1]);
            if (!$group) {
                abort(
                    500,
                    'system error' . (env('APP_DEBUG', false) ? ' [HidePendingMembersFieldWhenNeeded::patch]' : '')
                );
            }
            if ($group->visibility != 'restricted') {
                return $this->removePendingMembersField($response);
            }
        }

        return $response;
    }

    /**
     * @param Response $response
     * @return Response
     */
    protected function removePendingMembersField(Response $response): Response
    {
        $content = json_decode_response($response);
        if (!isset($content['data'])) {
            return $response;
        }
        $data = collect($content['data']);
        $pendingMembersKeys = $data->search(
            function ($field) {
                return isset($field['name']) && $field['name'] == 'pending_members';
            }
        );
        if ($pendingMembersKeys === false) {
            return $response;
        }
        $data->forget($pendingMembersKeys);
        $content['data'] = $data->values();
        set_response($response, $content);

        return $response;
    }
}
