<?php

namespace Inside\Groups\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @package Inside\Groups\Http\Middlewares
 */
class HideMembersFieldOnCreation
{
    public function handle(Request $request, Closure $next): mixed
    {
        $response = $next($request);
        if ($response instanceof Response && $response->getStatusCode() != 200) {
            return $response;
        }

        if (
            $request->getMethod() == 'GET'
            && ($request->path() == 'api/v1/form/groups')
        ) {
            $response = $this->patch($response);
        }

        return $response;
    }

    /**
     * @param Response $response
     * @return Response
     */
    protected function patch(Response $response): Response
    {
        $content = json_decode_response($response);
        if (!isset($content['data'])) {
            return $response;
        }
        $data = collect($content['data']);
        $pendingMembersKeys = $data->search(
            function ($field) {
                return isset($field['name']) && $field['name'] == 'members';
            }
        );
        if ($pendingMembersKeys === false) {
            return $response;
        }
        $data->forget($pendingMembersKeys);
        $content['data'] = $data->values();
        set_response($response, $content);

        return $response;
    }
}
