<?php

namespace Inside\Groups\Facades;

use Illuminate\Support\Facades\Facade;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Services\GroupsMembersService;

/**
 * @method static void removeUndesiredGroupMembers(Groups $originalGroup)
 * @method static void handleAdminsUpdated(Groups $originalGroup, array $oldAdmins = [])
 * @method static void updateMembers(Groups $originalGroup, array $newMembers)
 * @method static void unsubscribeUndesiredSubscribers(Groups $originalGroup)
 */
class GroupsMembers extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return GroupsMembersService::class;
    }
}
