<?php

namespace Inside\Groups\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\Users;
use Inside\Events\Dispatchable;

class UserJoinedAGroupEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public Groups $group,
        public User $user,
        public User $from
    ) {
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_groups.'.$this->group->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside_groups.members.joined';
    }
}
