<?php

namespace Inside\Groups\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Groups;
use Inside\Events\Dispatchable;

class UserAskedToJoinAGroupEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use Dispatchable;

    public function __construct(
        public Groups $group,
        public User $from
    ) {
    }

    /**
     * @return PrivateChannel
     */
    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_groups.admin.'.$this->group->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside_groups.members.pending.created';
    }
}
