<?php

namespace Inside\Groups\Console\Commands;

use Illuminate\Support\Facades\DB;
use Inside\Console\Command;
use Inside\Content\Models\Contents\Groups;

class RepairMissingRelationBetweenUsersRoles extends Command
{
    protected $signature = 'inside:groups:repair-users-roles';

    protected $description = 'Repair relations between users and roles';

    public function handle(): void
    {
        $this->info('Trying to fix missing relation between users and roles on inside_users_roles table');

        $groups = Groups::with('reverseUsers')->get();
        $roles = DB::table('inside_roles');

        $groups->each(fn ($group) => $roles->orWhere('name', 'LIKE', "%-{$group->uuid}-member"));

        $roles->pluck('name', 'id')
            ->map(fn ($name) => (string) str($name)->after('group-')->before('-member'))
            ->map(fn ($uuid) => $groups->firstWhere('uuid', $uuid))
            ->each(
                fn ($group, $roleId) => $group->reverseUsers
                ->reject(fn ($user) => DB::table('inside_users_roles')->where('user_uuid', $user->uuid)->where('role_id', $roleId)->exists())
                ->each(function ($user) use ($group, $roleId) {
                    $this->warn("[FIX] - Missing {$user->name} access on the group {$group->title} (Role #{$roleId})");

                    DB::table('inside_users_roles')->insert([
                        'user_uuid' => $user->uuid,
                        'role_id' => $roleId,
                    ]);
                })
            );
    }
}
