<?php

namespace Database\Seeders\Groups;

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Content\Models\Contents\Users;
use Inside\Groups\Models\GroupPost;
use Inside\Host\Bridge\BridgeContent;

class GroupSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run(): void
    {
        $bridge = new BridgeContent();
        $adminUuid = Users::where('email', 'technique@maecia.com')->first()->uuid;
        $fakes = Groups::where('title', 'like', '[FAKE]%')->get();
        foreach ($fakes as $fake) {
            $bridge->contentDelete('groups', $fake->uuid);
        }

        foreach (['public', 'private', 'restricted'] as $visibility) {
            $groupUuid = $bridge->contentInsert(
                'groups',
                [
                    'title'         => '[FAKE] <' . $visibility . '> Groupe de tests',
                    'members'       => [
                        [
                            'uuid'  => $adminUuid,
                            'admin' => true,
                        ],
                    ],
                    'bundle'        => 'groups',
                    'author'        => $adminUuid,
                    'has_documents' => false,
                    'image'         => null,
                    'introduction'  => 'Un groupe de tests (' . $visibility . ')',
                    'langcode'      => 'fr',
                    'status'        => true,
                    'type'          => 'node',
                    'visibility'    => $visibility,
                ]
            );

            GroupPost::factory()->count(50)->make(
                [
                    'groups' => [$groupUuid],
                ]
            )->each(
                function ($groupPost) use ($bridge) {
                    $bridge->contentInsert('groups_posts', $groupPost->toArray());
                }
            );

            GroupPost::factory()->count(100)->make(
                [
                    'groups' => [$groupUuid],
                ]
            )->each(
                function ($groupPost) use ($bridge, $groupUuid) {
                    $groupPost->groups_posts = [
                        GroupsPosts::whereHas(
                            'groups',
                            function ($query) use ($groupUuid) {
                                $query->where('inside_content_groups.uuid', $groupUuid);
                            }
                        )->inRandomOrder()->first()->uuid,
                    ];
                    $bridge->contentInsert('groups_posts', $groupPost->toArray());
                }
            );
        }
    }
}
