<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'categorizable'     => false,
        'permissible'       => true,
        'name'              => 'groups_posts',
        'title'             => [
            'fr' => 'Publications de groupes',
            'en' => 'Groups Posts',
        ],
    ],
    'fields'  => [
        // Contenu
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'body',
            'searchable'          => true,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Contenu',
                'en' => 'Content',
            ],
            'description'         => [
                'fr' => 'Contenu du poste',
                'en' => 'Post content',
            ],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],
        // Fichier
        [
            'type'                => BridgeContentType::FILE_FIELD,
            'name'                => 'file',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Fichier',
                'en' => 'File',
            ],
            'description'         => [
                'fr' => 'Fichier optionnel',
                'en' => 'Optionnal file',
            ],
            'widget'              => [
                'type'     => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.oasis.opendocument.text,text/plain,application/pdf,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,text/csv,application/vnd.ms-powerpoint,application/vnd.openxmlformats-officedocument.presentationml.presentation,application/postscript,image/jpeg,image/gif,image/png,image/svg+xml,image/tiff,video/mp4,video/x-msvideo,video/quicktime,video/webm',
                    'file_extensions' => 'doc docx odt txt pdf xls xlsx csv ppt pptx ai eps jpeg jpg gif png svg tif mp4 avi mov webm',
                    'max_filesize'    => 536870912,
                ],
            ],
        ],
        // Groupe
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Groupe',
                'en' => 'Group',
            ],
            'description'         => [
                'fr' => 'Le groupe',
                'en' => 'group',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Parent
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups_posts',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Parent',
                'en' => 'Parent',
            ],
            'description'         => [
                'fr' => 'Le parent du poste',
                'en' => 'Post\'s parent',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups_posts',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Post type
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'post_type',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Type de poste',
                'en' => 'Post type',
            ],
            'description'         => [
                'fr' => 'Indique le type de poste',
                'en' => 'Post type',
            ],
            'settings'            => [
                'allowed_values' => [
                    'comment' => [
                        'fr' => 'Commentaire',
                        'en' => 'Comment',
                    ],
                    'system'  => [
                        'fr' => 'Système',
                        'en' => 'Systeme',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
