<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'groups',
        'title'             => [
            'fr' => 'Groupes',
            'en' => 'Groups',
        ],
    ],
    'fields'  => [
        // Image
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Image',
                'en' => 'Image',
            ],
            'description'         => [
                'fr' => 'L\image illustrant le groupe',
                'en' => 'Group\'s image',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
            ],
        ],
        // Introduction
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'introduction',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description'         => [
                'fr' => 'Texte d\'introduction du groupe',
                'en' => 'Group\'s introduction',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
        ],
        // Visibility
        [

            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'visibility',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Visibilité',
                'en' => 'Visibility',
            ],
            'description'         => [
                'fr' => 'Indique qui peut voir ce groupe',
                'en' => 'Set group visibility',
            ],
            'settings'            => [
                'allowed_values' => [
                    'public'     => [
                        'fr' => 'Public',
                        'en' => 'Public',
                    ],
                    'private'    => [
                        'fr' => 'Privé',
                        'en' => 'Private',
                    ],
                    'restricted' => [
                        'fr' => 'Restreint',
                        'en' => 'Limited',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Médiathèque ?
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'has_documents',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'default'             => false,
            'title'               => [
                'fr' => 'Base documentaire',
                'en' => 'Documents',
            ],
            'description'         => [
                'fr' => 'Si vous souhaitez simplifier l\'apparence du groupe, vous pouvez désactiver la base documentaire. Dans ce cas, le module ne sera plus affiché mais aucun fichier ne sera supprimé.',
                'en' => 'If you want to simplify the appearance of the group, you can disable the document base. In this case, the module will no longer be displayed but no file will be deleted.',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
        ],
        // Membres
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'members',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Admins',
                'en' => 'Admins',
            ],
            'description'         => [
                'fr' => 'Liste des admins du groupes ( colonne special ou est ajouté les membres aux admins )',
                'en' => 'List of group admins (special column where members are added to admins)',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Membres en attente
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'pending_members',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Membres en attente',
                'en' => 'Pending members',
            ],
            'description'         => [
                'fr' => 'Liste des membres en attente pour rejoindre le groupe',
                'en' => 'List of members waiting to join the group',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
