<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class AddGroupRolesTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('group_roles')) {
            return;
        }

        Schema::create(
            'group_roles',
            function (Blueprint $table) {
                $table->unsignedInteger('group_id');
                $table->foreign('group_id')
                    ->references('id')
                    ->on('groups')
                    ->onDelete('cascade');

                $table->unsignedInteger('role_id');
                $table->foreign('role_id')
                    ->references('id')
                    ->on('inside_roles')
                    ->onDelete('cascade');

                $table->unique(['group_id', 'role_id']);
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('group_roles');
    }
}
