<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Services\Schema\SchemaService;

final class AddBannerPageStyleToGroupsImageField extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $schemaService = app(SchemaService::class);
        if (!$schemaService->hasField('groups', 'image')) {
            Log::emergency('Groups module is not correctly installed !');
            return;
        }

        $fieldOptions = $schemaService->getFieldOptions('groups', 'image');
        if (isset($fieldOptions['image_styles'])
            && is_array($fieldOptions['image_styles'])
            && in_array('banner_page', $fieldOptions['image_styles'])) {
            return;
        }
        $this->write('Mise-à-jour des styles d\'images des groupes');

        $bridgeType = new BridgeContentType();
        try {
            $bridgeType->updateFieldOptions(
                'groups',
                'image',
                [
                    'type' => BridgeContentType::IMAGE_FIELD,
                    'image_styles' => [
                        'banner_page',
                    ],
                ]
            );
            $this->writeResult(true);
        } catch (Exception $exception) {
            Log::error("[updateFieldOptions] failed to update image options {$exception->getMessage()}");
            $this->writeResult(false);
            return;
        }
        $this->writeln('<fg=green>Démarrage de la génération des images en tâche de fond ...</>');
        Artisan::call('inside:images:generate');
    }
}
