<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Log;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Groups;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class IntroductionGroupWysiwyg extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        // for previous existing instances that have already run the global content groups migration
        if (! Schema::hasField('groups', 'groups_introduction')) {
            $bridgeType->contentTypeCreateOrUpdateField('groups', 'groups_introduction', [
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'name' => 'groups_introduction',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => true,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'description' => [
                    'fr' => 'Texte d\'introduction du groupe',
                    'en' => 'Group\'s introduction',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
            ], 2);
        }

        if (Schema::hasField('groups', 'introduction')) {
            // copy all content of introduction to groups_introduction
            $bridgeContent = new BridgeContent();
            $groups = Groups::all();
            foreach ($groups as $group) {
                try {
                    $intro = $group->introduction;
                    $uuid = $group->uuid;
                    $bridgeContent->contentUpdate('groups', [
                        'uuid' => $uuid,
                        'groups_introduction' => $group->introduction,
                    ]);
                } catch (Exception $e) {
                    Log::error('Error during introduction migration for group ' . $uuid . ' : ' . $e->getMessage());
                }
            }

            // delete introduction field
            $bridgeType->contentTypeDeleteField('node', 'groups', 'introduction');
        }
    }
}
