<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Output\ConsoleOutput;

class MakeGroupsFieldFilterable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // Prepare a console
        $output      = new ConsoleOutput();
        $outputStyle = new OutputFormatterStyle('white', 'green', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('module', $outputStyle);
        $outputStyle = new OutputFormatterStyle('yellow', 'default', ['bold', 'blink', 'underscore']);
        $output->getFormatter()->setStyle('class', $outputStyle);

        $output->writeln("<info>Passage du champ groups en filtrable</info>");

        $bridge = new BridgeContentType();

        // Add groups field to users
        $users_groups = include __DIR__ . '/fields/users/groups.php';

        try {
            $bridge->updateFieldOptions('users', 'groups', ['searchable_filter' => true]);
        } catch (Exception $e) {
            dd($e);
        }

        Artisan::call('index:rebuild', ['--type' => 'users']);

        $output->writeln("<comment>Fait</comment>");
    }

    public function down(): void
    {
    }
}
