<?php

use Illuminate\Database\Migrations\Migration;

class MigrateNotificationToRoleNotification extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        \Inside\Notify\Models\NotificationType::where(
            [
                'via'    => 'web',
                'event'  => 'Inside\Groups\Events\GroupsDocumentsCreatedEvent',
                'model'  => 'Inside\Content\Models\Contents\GroupsDocuments',
                'type'   => 'group',
                'action' => 'custom',
            ]
        )->each(
            function ($notificationType) {
                $notificationType->role = true;
                $notificationType->save();
            }
        );
    }

    public function down(): void
    {
    }
}
