<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Groups\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('groups/posts/{uuid}/index', ['uses' => 'GroupsController@posts']);
        $router->get('groups/posts/{uuid}', ['uses' => 'GroupsController@post']);
        $router->get('groups/index', ['uses' => 'GroupsController@groups']);
        $router->get('groups/list', ['uses' => 'GroupsController@simpleListGroups']);
        $router->post('groups/join/{uuid}', ['uses' => 'GroupsController@askToJoin']);
        $router->get('groups/members/{uuid}', ['uses' => 'GroupsController@members']);
        $router->get('groups/subscribe/{uuid}', ['uses' => 'GroupsController@isSubscribed']);
        $router->get('groups/member/{uuid}', ['uses' => 'GroupsController@isMember']);
        $router->get('groups/admin/{uuid}', ['uses' => 'GroupsController@isAdmin']);
        $router->post('groups/subscribe/{uuid}', ['uses' => 'GroupsController@subscribe']);
        $router->delete('groups/subscribe/{uuid}', ['uses' => 'GroupsController@unsubscribe']);
    }
);
