<?php

namespace Inside\Groups\Providers;

use Inside\Content\Contracts\Transformer;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentProcessedEvent;
use Inside\Content\Events\UserMentionedInCommentEvent;
use Inside\Groups\Console\Commands\RepairMissingRelationBetweenUsersRoles;
use Inside\Groups\Console\Commands\GroupsSyncRolesCommand;
use Inside\Groups\Events\UserAskedToJoinAGroupEvent;
use Inside\Groups\Events\UserGrantedAdminEvent;
use Inside\Groups\Events\UserJoinedAGroupEvent;
use Inside\Groups\Events\UserRevokedAdminEvent;
use Inside\Groups\Http\Middlewares\GroupContentsPermissionMiddleware;
use Inside\Groups\Http\Middlewares\GroupsRolesMiddleware;
use Inside\Groups\Http\Middlewares\HideMembersFieldOnCreation;
use Inside\Groups\Http\Middlewares\HidePendingMembersFieldWhenNeeded;
use Inside\Groups\Http\Middlewares\HideSpecificPermissionMiddleware;
use Inside\Groups\Http\Middlewares\MembersFieldMiddleware;
use Inside\Groups\Listeners\GrantUserAdminListener;
use Inside\Groups\Listeners\GroupsCleanupListener;
use Inside\Groups\Listeners\GroupsDocumentsCleanupListener;
use Inside\Groups\Listeners\GroupsDocumentsListener;
use Inside\Groups\Listeners\GroupsActivityListener;
use Inside\Groups\Listeners\GroupsListener;
use Inside\Groups\Listeners\GroupsPostsListener;
use Inside\Groups\Listeners\ManageGroupsPostsAttachmentsListener;
use Inside\Groups\Listeners\RevokeUserAdminListener;
use Inside\Groups\Listeners\RoleDeletedListener;
use Inside\Groups\Listeners\SynchronizeGroup;
use Inside\Groups\Listeners\SynchronizeGroupPost;
use Inside\Groups\Listeners\UserAskedToJoinAGroupListener;
use Inside\Groups\Listeners\UserJoinAGroupListener;
use Inside\Groups\Listeners\UserMentionedInGroupListener;
use Inside\Groups\Repositories\GroupPostRepository;
use Inside\Groups\Services\GroupsMembersService;
use Inside\Groups\Services\GroupsService;
use Inside\Permission\Events\RoleDeletedEvent;
use Inside\Support\EventServiceProvider;

/**
 * @package Inside\Groups\Providers
 */
class GroupsServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentInsertedEvent::class => [
            GroupsDocumentsListener::class,
            GroupsPostsListener::class,
            GroupsListener::class,
            ManageGroupsPostsAttachmentsListener::class,
        ],
        ContentDeletedEvent::class => [
            GroupsCleanupListener::class,
            GroupsDocumentsCleanupListener::class,
        ],
        ContentProcessedEvent::class => [
            GroupsActivityListener::class,
        ],
        UserJoinedAGroupEvent::class => [
            UserJoinAGroupListener::class,
        ],
        UserAskedToJoinAGroupEvent::class => [
            UserAskedToJoinAGroupListener::class,
        ],
        UserGrantedAdminEvent::class => [
            GrantUserAdminListener::class,
        ],
        UserRevokedAdminEvent::class => [
            RevokeUserAdminListener::class,
        ],
        UserMentionedInCommentEvent::class => [
            UserMentionedInGroupListener::class,
        ],
        RoleDeletedEvent::class => [
            RoleDeletedListener::class,
        ],
    ];

    protected array $subscribe = [
        SynchronizeGroup::class,
        SynchronizeGroupPost::class,
    ];

    protected array $commands = [
        RepairMissingRelationBetweenUsersRoles::class,
        GroupsSyncRolesCommand::class,
    ];

    public array $bindings = [
        'groups.helper' => GroupsService::class,
        GroupsMembersService::class => GroupsMembersService::class,
    ];

    public function boot(): void
    {
        parent::boot();

        $this->app->singleton(
            GroupPostRepository::class,
            function ($app) {
                $transformer = $app->make(Transformer::class);
                return new GroupPostRepository($transformer);
            }
        );
    }

    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/archive.php', 'archive');

        $this->app->middleware(
            [
                MembersFieldMiddleware::class,
                HideMembersFieldOnCreation::class,
                HidePendingMembersFieldWhenNeeded::class,
                HideSpecificPermissionMiddleware::class,
                GroupContentsPermissionMiddleware::class,
                GroupsRolesMiddleware::class,
            ]
        );
    }
}
