<?php

namespace Inside\Groups\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Events\UserMentionedInCommentEvent;
use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class UserMentionedInGroupListener extends BaseNotificationListener implements ShouldQueue
{
    public ?string $queue;

    public function __construct()
    {
        $this->queue = get_low_priority_queue_name();
    }

    public function handle(UserMentionedInCommentEvent $event): void
    {
        if ($event->commentType !== 'groups_posts') {
            return;
        }

        $comment = GroupsPosts::find($event->commentUuid);
        if (!$comment) {
            return;
        }
        $group = $comment->groups->first();
        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('model', GroupsPosts::class)
            ->where('condition', 'groups:'.$group->uuid)
            ->where('type', 'group')->where('action', 'custom')
            ->where('event', UserMentionedInCommentEvent::class)
            ->get();

        /** @var ?User $subscriber */
        $subscriber = User::find($event->userUuid);
        if (!$subscriber) {
            return;
        }

        foreach ($types as $type) {
            $this->when = $this->getInterval($type, $comment);
            $this->route = $subscriber;
            if (!$this->checkUniqueness($type, $comment, $subscriber) || !$subscriber->status) {
                continue;
            }
            $this->notify($type, $subscriber, $comment, ['from' => $comment->author]);
        }
    }
}
