<?php

declare(strict_types=1);

namespace Inside\Groups\Listeners;

use Inside\Content\Models\Contents\Groups;
use Inside\Host\Bridge\BridgeContent;
use Inside\Permission\Events\RoleDeletedEvent;

class RoleDeletedListener
{
    /**
     * Delete freshly deleted role_id from Groups groups_roles lists
     */
    public function handle(RoleDeletedEvent $event): void
    {
        $bridge = new BridgeContent();

        $roleId = $event->role->id;

        Groups::query()
            ->select(['uuid', 'groups_roles'])
            ->selectRaw("CONCAT(',', groups_roles, ',') as roleIds")
            ->having('roleIds', 'like', "%,$roleId,%")
            ->each(function (Groups $group) use ($bridge, $roleId) {
                $newRoles = str($group->groups_roles)
                    ->explode(',')
                    ->reject(fn (string $item) => intval($item) === $roleId)
                    ->join(',');

                $bridge->contentUpdate('groups', [
                    'uuid' => $group->uuid,
                    'groups_roles' => $newRoles ?: null,
                ]);
            });
    }
}
