<?php

namespace Inside\Groups\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Models\Contents\GroupsFolders;
use Inside\Host\Bridge\BridgeContent;

class ManageGroupsPostsAttachmentsListener implements ShouldQueue
{
    /**
     * @param ContentInsertedEvent $event
     * @return void
     * @throws Exception
     */
    public function handle(ContentInsertedEvent $event): void
    {
        if (isset($event->model->content_type) && ($event->model->content_type == 'groups_posts')) {
            $post = $event->model;
            $groups = $post->groups;
            if ($groups === null || $groups->isEmpty()) {
                return;
            }

            $group = $groups->first();
            if ($post->author === null) {
                return;
            }

            if ($post->file === null) {
                return;
            }

            $folder = GroupsFolders::whereHas(
                'groups',
                function ($query) use ($group) {
                    return $query->where('inside_content_groups.uuid', $group->uuid);
                }
            )->where('title', Lang::get('folders.attachements.title'))->where('langcode', $group->langcode)
                                   ->first();

            $bridge = new BridgeContent();
            if (!$folder) {
                $uuid = $bridge->contentInsert(
                    'groups_folders',
                    [
                        'type' => 'node',
                        'bundle' => 'groups_folders',
                        'langcode' => $group->langcode,
                        'title' => Lang::get('folders.attachements.title'),
                        'groups' => [$group->uuid],
                        'status' => true,
                    ]
                );
                $folder = GroupsFolders::find($uuid);
            }

            $bridge->contentInsert(
                'groups_documents',
                [
                    'type'           => 'node',
                    'bundle'         => 'groups_documents',
                    'content'        => [],
                    'langcode'       => $group->langcode,
                    'title'          => basename($post->file),
                    'groups'         => [$group->uuid],
                    'groups_folders' => [$folder->uuid],
                    'author'         => $post->author,
                    'status'         => true,
                    'file'           => $post->file,
                ]
            );
        }
    }
}
