<?php

namespace Inside\Groups\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Models\Contents\GroupsDocuments;
use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Facades\Log;

class GroupsDocumentsCleanupListener implements ShouldQueue
{
    public ?string $queue;

    public function __construct()
    {
        $this->queue = get_low_priority_queue_name();
    }

    public function handle(ContentDeletedEvent $event): void
    {
        $post = $event->model;

        if (! $post instanceof GroupsPosts) {
            return;
        }

        $groupDocument = type_to_class('groups_documents')::query()
            ->where('title', basename($post->file))
            ->where('file', $post->file)
            ->first();
        if (! $groupDocument instanceof GroupsDocuments) {
            return;
        }

        $bridgeContent = new BridgeContent();
        $bridgeContent->contentDelete('groups_documents', $groupDocument->uuid);
        Log::info('[GROUPS_DOCUMENTS_SYNC] '.$groupDocument->title.' Deleted !');
    }
}
