<?php

namespace Inside\Groups\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Str;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Models\NotificationType;

/**
 * @package Inside\Groups\Listeners
 */
class GroupsCleanupListener implements ShouldQueue
{
    /**
     * @var string|null
     */
    public $queue;

    public function __construct()
    {
        $this->queue = get_low_priority_queue_name();
    }

    /**
     * @param ContentDeletedEvent $event
     * @return void
     */
    public function handle(ContentDeletedEvent $event): void
    {
        if (isset($event->model) && ($event->model->content_type == 'groups')) {
            $group = $event->model;
            NotificationType::where('type', 'group')->where('condition', 'groups:' . $group->uuid)->delete();
            $bridge = new BridgeContent();
            foreach (GroupsHelper::getGroupContentTypes() as $type) {
                $group->{Str::camel('reverse_' . $type)}->each(
                    function ($content) use ($bridge, $type) {
                        $bridge->contentDelete($type, $content->uuid);
                    }
                );
            }
        }
    }
}
