<?php

namespace Inside\Groups\Jobs;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Groups\Events\UserJoinedAGroupEvent;
use Inside\Groups\Events\UserLeftAGroupEvent;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Groups\Models\Group;
use Inside\Jobs\Job;
use Inside\Notify\Models\NotificationType;

class DeleteUsersFromGroup extends Job
{
    public function __construct(
        private Collection $users,
        private Group $group,
        private User $from
    ) {
    }

    public function handle(): void
    {
        foreach ($this->users->chunk(50) as $members) {
            $members->each(function (User $user) {
                GroupsHelper::removeUserFromGroupMembers($user->uuid, $this->group->original);
                UserLeftAGroupEvent::dispatch($this->group->original, $user, $this->from);
            });
        }

        NotificationType::where('condition', "groups:$this->group->original_uuid")->where('action', 'custom')
            ->each(fn (NotificationType $type) => $type->subscribers()->detach($this->users->pluck('uuid')));
    }
}
