<?php

namespace Inside\Groups\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Inside\Groups\Facades\GroupsHelper;

class HideSpecificPermissionMiddleware
{
    protected array $paths = [
        'api/v1/form/groups',
    ];

    public function __construct()
    {
        foreach (GroupsHelper::getGroupContentTypes() as $type) {
            $this->paths[] = 'api/v1/form/' . $type;
        }
    }

    public function handle(Request $request, Closure $next): mixed
    {
        $response = $next($request);
        if ($response instanceof Response && $response->getStatusCode() != 200) {
            return $response;
        }

        if (
            $request->getMethod() == 'GET'
            && in_array($request->path(), $this->paths)
        ) {
            $response = $this->patch($response);
        }

        return $response;
    }

    protected function patch(Response $response): Response
    {
        $content = json_decode_response($response);
        if (!isset($content['data'])) {
            return $response;
        }
        $data = collect($content['data']);
        $groupPermissionsKeys = $data->search(
            function ($field) {
                return isset($field['id']) && $field['id'] == 'group_permissions';
            }
        );
        if ($groupPermissionsKeys === false) {
            return $response;
        }
        $data->forget($groupPermissionsKeys);
        $content['data'] = $data->values();
        set_response($response, $content);

        return $response;
    }
}
