<?php

namespace Inside\Groups\Facades;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Models\Group;
use Inside\Groups\Models\GroupPost;

/**
 * @method static void touch(Groups $group)
 * @method static void addUserToGroupMembers(string $userUuid, Groups $group)
 * @method static void removeUserFromGroupAdmins(string $userUuid, Groups $group)
 * @method static void removeUserFromGroupPendingMembers(string $userUuid, Groups $group)
 * @method static void removeUserFromGroupMembers(string $userUuid, Groups $group)
 * @method static Collection getGroupMembers(Groups $group, string $excluded = null)
 * @method static bool can(string $action, string $type, ?string $uuid, ?User $user)
 * @method static bool isGroupAdmin(Groups $group, mixed $user)
 * @method static bool isGroupContentType(string $type)
 * @method static array getGroupContentTypes()
 * @method static bool isGroupMember(Groups $group, Authenticatable $user)
 * @method static bool isGroupPendingMember(Groups $group, User $user)
 * @method static array getUserVisibleGroupsUuids(User $user)
 * @method static void groupsTypesVisibilityScope(Builder $builder)
 * @method static void groupsVisibilityScope(Builder $builder)
 * @method static void setPermission(string $type, ?string $uuid, string $action, bool $granted, string $role)
 * @method static void createNotificationsForNewGroup(Groups $group)
 * @method static void createIfNecessaryNotificationType(Collection $users, string $via, Groups $group, string $event, string $model, string $langKey, bool $role)
 * @method static void addGroupContentType(string $type)
 * @method static void updateLasGroupActivityActivity(Group $group)
 * @method static bool isNewMessage(GroupPost $message)
 */
class GroupsHelper extends Facade
{
    /**
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return 'groups.helper';
    }
}
