<?php

namespace Inside\Groups\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Events\Dispatchable;
use Inside\Groups\Models\GroupPost;

class GroupPostCreated implements ShouldBroadcast
{
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public GroupPost $post
    ) {
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside_groups.'.$this->post->group->original_uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside_groups.post.created';
    }
}
