<?php

declare(strict_types=1);

namespace Inside\Groups\Console\Commands;

use Illuminate\Support\Facades\DB;
use Inside\Console\Command;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Models\Group;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Models\Role;

final class GroupsSyncRolesCommand extends Command
{
    protected $signature = 'inside:groups:sync:roles';

    protected $description = 'Sync Groups members with associated roles';

    public function handle(): void
    {
        $count = Group::count();
        $this->info("Synching groups members and associated roles ($count groups)");
        $this->getOutput()->progressStart($count);

        Group::each(function (Group $group) {
            /** @var Role $membersRole */
            $membersRole = Role::firstOrCreate(
                [
                    'name' => "group-$group->original_uuid-member",
                    'type' => 'group',
                ]
            );

            /** @var Role $adminRole */
            $adminRole = Role::firstOrCreate(
                [
                    'name' => "group-$group->original_uuid-admin",
                    'type' => 'group',
                ]
            );

            $membersRole->users()->sync($group->members->pluck('uuid')->unique()->values());
            $adminRole->users()->sync($group->admins->pluck('uuid')->unique()->values());
            $this->getOutput()->progressAdvance();
        });

        $this->getOutput()->progressFinish();
        $this->info('Groups members synchronized');
    }
}
