<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'groups_documents',
        'title'             => [
            'fr' => 'Documents de groupes',
            'en' => 'Groups\'s documents',
        ],
    ],
    'fields'  => [
        // Groupe
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => true,
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Groupe',
                'en' => 'Group',
            ],
            'description'         => [
                'fr' => 'Le groupe',
                'en' => 'group',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Folders
        [
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'name'                => 'groups_folders',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'classifiable'        => 'groups',
            'required'            => true,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Dossier parent',
                'en' => 'Parent folder',
            ],
            'description'         => [
                'fr' => 'Le dossier parent',
                'en' => 'Parent folder',
            ],
            'settings'            => [
                'cardinality' => -1,
                'target_type' => 'groups_folders',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        // Fichier
        [
            'type'                => BridgeContentType::FILE_FIELD,
            'name'                => 'file',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Fichier',
                'en' => 'File',
            ],
            'description'         => [
                'fr' => 'Fichier optionnel',
                'en' => 'Optionnal file',
            ],
            'widget'              => [
                'type'     => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.oasis.opendocument.text,text/plain,application/pdf,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,text/csv,application/vnd.ms-powerpoint,application/vnd.openxmlformats-officedocument.presentationml.presentation,application/postscript,image/jpeg,image/gif,image/png,image/svg+xml,image/tiff,video/mp4,video/x-msvideo,video/quicktime,video/webm,application/zip',
                    'file_extensions' => 'doc docx odt txt pdf xls xlsx csv ppt pptx ai eps jpeg jpg gif png svg tif mp4 avi mov webm zip',
                    'max_filesize'    => 536870912,
                ],
            ],
        ],
        // Contenu
        [
            'type'                => BridgeContentType::SECTION_FIELD,
            'name'                => 'content',
            'searchable'          => true,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'title'               => [
                'fr' => 'Contenu',
                'en' => 'Content',
            ],
            'description'         => [
                'fr' => 'Paragraphes',
                'en' => 'Pargraphs',
            ],
            'settings'            => [
                'target_type' => [
                    'file',
                    'html',
                    'image',
                    'map',
                    'text',
                    'text_with_image',
                    'video',
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [],
            ],
        ],
    ],
];
