<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddGroupsRolesField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        // Add a string field groups_roles wich is a coma separated list of role_id
        $this->getBridge()?->contentTypeCreateOrUpdateField('groups', 'groups_roles', [
            'type' => BridgeContentType::TEXT_FIELD,
            'name' => 'groups_roles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Rôles',
                'en' => 'Roles',
            ],
            'description' => [
                'fr' => 'Les rôles ayant accès au groupe',
                'en' => 'Roles than can access the group',
            ],
            'settings' => [
                'cardinality' => 1,
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
        ]);
        $this->finishUp();
    }
}
