<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Events\UserMentionedInCommentEvent;
use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\GroupsPosts;
use Inside\Content\Models\Contents\Users;
use Inside\Groups\Services\GroupsService;

class AddGroupsMentionNotifications extends Migration
{
    public function up(): void
    {
        $groups = Groups::all();
        $users = Users::all();

        $service = new GroupsService();

        foreach ($groups as $group) {
            // Un utilisateur est mentionné dans un groupe
            $service->createIfNecessaryNotificationType(
                $users,
                'web',
                $group,
                UserMentionedInCommentEvent::class,
                GroupsPosts::class,
                'mention',
                false
            );
            $service->createIfNecessaryNotificationType(
                $users,
                'email',
                $group,
                UserMentionedInCommentEvent::class,
                GroupsPosts::class,
                'mention',
                false
            );
        }
    }

    public function down(): void
    {
    }
}
