<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Groups\Events\UserJoinedAGroupEvent;

class FixUserJoinedGroupNotifications extends Migration
{
    public function up(): void
    {
        \Inside\Notify\Models\NotificationType::where(
            [
                'event'  => 'Inside\Groups\Events\UserJoinAGroupEvent',
                'model'  => 'Inside\Content\Models\Contents\Groups',
                'type'   => 'group',
                'action' => 'custom',
            ]
        )->each(
            function ($notificationType) {
                $notificationType->event = UserJoinedAGroupEvent::class;
                $notificationType->save();
            }
        );
    }

    public function down(): void
    {
    }
}
