<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Groups\Models\Group;
use Inside\Groups\Models\GroupPost;

class SynchronizeToNewGroupSystem extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $this->writeln('<fg=white><bg=blue>Migration des anciens groupes.</bg=blue></fg=white>');
        $this->separatorLine();
        $this->writeln('<fg=yellow>Création des groupes.</fg=yellow>');
        Group::each(
            function ($group) {
                $group->delete();
            }
        );

        Groups::each(
            function ($group) {
                $this->write('Synchronisation du groupe <fg=magenta>' . trim($group->title) . '</fg=magenta>');
                $newGroup = Group::create(
                    [
                        'enabled'       => $group->status,
                        'name'          => $group->title,
                        'slug'          => $group->slug[0],
                        'description'   => $group->introduction,
                        'original_uuid' => $group->uuid,
                        'image'         => $group->image,
                        'type'          => $group->visibility,
                        'author_uuid'   => $group->author,
                        'created_at'    => $group->created_at,
                        'updated_at'    => $group->updated_at,
                    ]
                );
                $members  = $group->belongsToMany(
                    Users::class,
                    'inside_pivots',
                    'related_uuid',
                    'parent_uuid'
                )->where('related_field', 'groups')->pluck('uuid')->toArray();

                $admins   = $group->members->pluck('uuid')->toArray();
                $pendings = $group->pendingMembers->pluck('uuid')->toArray();

                $toSync = [];
                foreach ($members as $member) {
                    $type = 'member';
                    if (in_array($member, $admins)) {
                        $type = 'admin';
                    }
                    $toSync[$member] = ['type' => $type];
                }
                foreach ($pendings as $pending) {
                    $toSync[$pending] = ['type' => 'pending'];
                }

                $newGroup->users()->sync($toSync);

                $this->writeResult(true);

                $postsSync = [];
                $this->write(
                    'Synchronisation des publications de groupe <fg=magenta>' . trim($group->title) . '</fg=magenta>'
                );
                foreach ($group->reverseGroupsPosts()->whereNull('pid')->get() as $groupsPost) {
                    $postsSync[$groupsPost->uuid] = GroupPost::create(
                        [
                            'group_id'      => $newGroup->id,
                            'parent_id'     => null,
                            'body'          => $groupsPost->body ?? '',
                            'file'          => $groupsPost->file,
                            'original_uuid' => $groupsPost->uuid,
                            'author_uuid'   => $groupsPost->author,
                            'created_at'    => $groupsPost->created_at,
                            'updated_at'    => $groupsPost->updated_at,
                        ]
                    );
                }
                $this->writeResult(true);
                $this->write(
                    'Synchronisation des réponses du groupe <fg=magenta>' . trim($group->title) . '</fg=magenta>'
                );
                foreach ($group->reverseGroupsPosts()->whereNotNull('pid')->get() as $groupsPost) {
                    GroupPost::create(
                        [
                            'group_id'      => $newGroup->id,
                            'parent_id'     => $postsSync[$groupsPost->pid]->id ?? null,
                            'body'          => $groupsPost->body ?? '',
                            'file'          => $groupsPost->file,
                            'original_uuid' => $groupsPost->uuid,
                            'author_uuid'   => $group->author,
                            'created_at'    => $groupsPost->created_at,
                            'updated_at'    => $groupsPost->updated_at,
                        ]
                    );
                }
                $this->writeResult(true);
                $this->separatorLine('cyan');
            }
        );
    }

    public function down(): void
    {
    }
}
