<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema;

class NewGroupSystem extends Migration
{
    public function up(): void
    {
        Schema::create(
            'groups',
            function (Blueprint $table) {
                $table->increments('id');
                $table->string('name', 255);
                $table->string('slug', 255)->unique();
                $table->string('image', 255)->nullable();
                $table->text('description')->nullable();
                $table->uuid('original_uuid')->comment('from inside content')->unique();
                $table->enum('header_text_style', ['light', 'dark'])->default('dark');
                $table->enum('type', ['private', 'public', 'restricted'])->default('public');
                $table->boolean('enabled')->default(true)->index();
                $table->uuid('author_uuid')->collate('utf8');
                $table->foreign('author_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('original_uuid')->references('uuid')->on('inside_content_groups')->onDelete('cascade');
                $table->timestamp('last_activity')->nullable()->default(null);
                $table->unsignedInteger('posts_count')->default(0);
                $table->timestamps();
            }
        );

        Schema::create(
            'group_members',
            function (Blueprint $table) {
                $table->unsignedInteger('group_id');
                $table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
                $table->uuid('user_uuid')->collate('utf8');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->unique(['group_id', 'user_uuid']);
                $table->enum('type', ['member', 'admin', 'pending'])->default('pending');
            }
        );

        Schema::create(
            'group_posts',
            function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('group_id');
                $table->unsignedInteger('parent_id')->nullable()->default(null);
                $table->text('body');
                $table->string('file', 255)->nullable()->default(null);
                $table->unsignedInteger('replies_count')->default(0);
                $table->uuid('original_uuid')->comment('from inside content')->unique();
                $table->uuid('author_uuid')->collate('utf8');
                $table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
                $table->foreign('parent_id')->references('id')->on('group_posts')->onDelete('cascade');
                $table->foreign('author_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->foreign('original_uuid')->references('uuid')->on('inside_content_groups_posts')->onDelete(
                    'cascade'
                );
                $table->timestamps();
            }
        );
        DB::statement('ALTER TABLE group_posts ADD FULLTEXT fulltext_body(body)');

        Schema::create(
            'group_activities',
            function (Blueprint $table) {
                $table->increments('id');
                $table->unsignedInteger('group_id');
                $table->uuid('user_uuid')->collate('utf8');
                $table->foreign('group_id')->references('id')->on('groups')->onDelete('cascade');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
                $table->timestamp('last_activity_at');
                $table->unique(['group_id', 'user_uuid']);
            }
        );
    }

    public function down(): void
    {
        Schema::drop('group_members');
        Schema::drop('group_activities');
        Schema::drop('group_posts');
        Schema::drop('groups');
    }
}
