<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditPendingMembersLabel extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateField(
            'groups',
            'pending_members',
            [
                'type'                => BridgeContentType::REFERENCE_FIELD,
                'name'                => 'pending_members',
                'searchable'          => false,
                'translatable'        => false,
                'search_result_field' => true,
                'required'            => false,
                'weight'              => 6,
                'title'               => [
                    'fr' => 'Membres en attente',
                    'en' => 'Pending members',
                ],
                'description'         => [
                    'fr' => 'Liste des membres en attente pour rejoindre le groupe',
                    'en' => 'List of members waiting to join the group',
                ],
                'settings'            => [
                    'cardinality' => -1,
                    'target_type' => 'users',
                ],
                'widget'              => [
                    'type'     => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
