<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Groups;
use Inside\Notify\Facades\NotificationType as NotificationTypeHelper;

class AddRoleToNotifications extends Migration
{
    public function up(): void
    {
        \Inside\Notify\Models\NotificationType::where(
            [
                'via'    => 'web',
                'event'  => 'Inside\Groups\Events\GroupsDocumentsCreatedEvent',
                'model'  => 'Inside\Content\Models\Contents\GroupsDocuments',
                'type'   => 'group',
                'action' => 'custom',
            ]
        )->each(
            function ($notificationType) {
                $uuid  = str_replace('groups:', '', $notificationType->condition);
                $group = Groups::find($uuid);

                if (!$group) {
                    return;
                }

                $notPublic = $group->visibility != 'public';
                $roleName  = $notPublic ? 'group-' . $group->uuid . '-member' : 'authenticated';
                NotificationTypeHelper::subscribeRoles($notificationType, $roleName, true);
            }
        );
    }

    public function down(): void
    {
    }
}
