<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Groups;
use Inside\Groups\Events\UserAskedToJoinAGroupEvent;
use Inside\Notify\Models\NotificationType;

class ChangeUrlMemberPendingGroupNotifications extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::where(
            [
                'via'    => 'web',
                'event'  => UserAskedToJoinAGroupEvent::class,
                'model'  => Groups::class,
                'action' => 'custom',
                'type'   => 'group',
            ]
        )->each(
            function ($notificationType) {
                $data        = $notificationType->data;
                $data['url'] = 'EDIT';

                $notificationType->data = $data;
                $notificationType->save();
            }
        );
    }

    public function down(): void
    {
    }
}
