<?php

use Illuminate\Database\Migrations\Migration;

class FixWebGroupNotifications extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        \Inside\Notify\Models\NotificationType::where(
            [
                'via'    => 'web',
                'event'  => 'Inside\Groups\Events\GroupsDocumentsCreatedEvent',
                'model'  => 'Inside\Content\Models\Contents\GroupsDocuments',
                'type'   => 'group',
                'action' => 'custom',
            ]
        )->each(
            function ($notificationType) {
                $data = $notificationType->data;

                $data['fields'] = [
                    'title',
                    ['groups' => ['title', 'slug']],
                ];

                $notificationType->data = $data;
                $notificationType->save();
            }
        );
    }

    public function down(): void
    {
    }
}
