<?php

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixGroupLikeNotifications extends Migration
{
    public function up(): void
    {
        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes = NotificationType::query()->where('type', 'group')->where('action', 'like')->get();

        foreach ($notificationTypes as $notificationType) {
            $data = $notificationType->data;
            if ($notificationType->via === 'email') {
                $data['text']         = 'notifications.group.email.like.groups_posts.text';
                $data['mail']['text'] = 'notifications.group.email.like.groups_posts.text';
            } else {
                $data['text'] = 'notifications.group.web.like.groups_posts.text';
            }

            $notificationType->data = $data;

            $notificationType->save();
        }
    }

    public function down(): void
    {
    }
}
