<?php

namespace Database\Factories\Groups\Models;

use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Eloquent\Factories\Factory;
use Inside\Groups\Models\GroupPost;

class GroupPostFactory extends Factory
{
    protected string $model = GroupPost::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition(): array
    {
        return [
            'body'   => $this->faker->sentences(3, true),
            'file'   => $this->faker->boolean(30) ? $this->faker->imageUrl(360, 360, 'animals', true, 'cats') : null,
            'bundle' => 'groups_posts',
            'groups' => Groups::where('status', true)->inRandomOrder()->first()->uuid,
            'author' => Users::where('status', true)->inRandomOrder()->first()->uuid,
            'title'  => 'fake_' . $this->faker->uuid,
        ];
    }
}
