<?php

use Inside\Authentication\Models\User;
use Inside\Groups\Facades\GroupsHelper;

return [
    'hidden_types' => [
        'groups',
        'groups_posts',
        'groups_documents',
        'groups_folders',
    ],
    'apply_permission_scope' => function ($user, $model) {
        return ! in_array($model->content_type, [...GroupsHelper::getGroupContentTypes(), 'groups']);
    },
    'global_scope' => [
        function ($builder, $user, $model) {
            if ($model->content_type === 'groups') {
                GroupsHelper::groupsVisibilityScope($builder);
            }

            if (in_array($model->content_type, ['groups_posts', 'groups_documents', 'groups_folders'])) {
                GroupsHelper::groupsTypesVisibilityScope($builder);
            }
        },
    ],
    'in_add_list' => [],
    'has_role' => [
        function (string $type) {
            if ($type == 'groups') {
                return false;
            }
        },
    ],
    'non_implicit_permission_to_author_content_types' => [
        'groups_documents',
        'groups_folders',
    ],
    'custom_permissions' => [
        function (string $action, string $type, ?string $uuid, ?User $user = null): bool {
            return GroupsHelper::can($action, $type, $uuid, $user);
        },
    ],
];
