<?php

namespace Inside\Form\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Listeners\BaseContentListener;

/**
 * Content deleted listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentDeletedListener extends BaseContentListener implements ShouldQueue
{
    /**
     * @inheritDoc
     */
    public function handle(ContentDeletedEvent $event): void
    {
        $model = $event->model;

        DB::table('inside_forms_answers')->where('answer', '"'.$model->uuid.'"')->update([
            'answer' => null,
        ]);
    }
}
