<?php

namespace Inside\Form\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Inside\Authentication\Models\User;
use Inside\Content\Listeners\NotifyUserOfCompletedExport;
use Inside\Form\Facades\FormUsers;
use Inside\Form\Services\FormExporterService;

class ExportSubmissionsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected string $related;

    protected string $userUuid;

    public function __construct(string $related, string $userUuid)
    {
        $this->related = $related;
        $this->userUuid = $userUuid;
    }

    public function handle(FormExporterService $service): void
    {
        /** @var ?User $user */
        $user = User::find($this->userUuid);

        FormUsers::setUserAuthenticatedForJob($user);
        $result = $service->exportSubmissions($this->related);

        if (empty($result['path']) || ! $user) {
            return;
        }

        dispatch(new NotifyUserOfCompletedExport(
            $user,
            $result['path'],
            'protected'
        ))->onQueue(get_low_priority_queue_name());
    }
}
